# Shebang goes here

# Program   :   abend2csv.awk   
# Purpose   :   Parse through Netware ABEND.LOG, gather stats
# Author    :   Bob Jonkman   <bjonkman@sobac.com>

# Copyright 2008 Bob Jonkman and/or SOBAC Microcomputer Services

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Date      :   20 July 2007

function leftzero(num,zeros)    {   # zeros is a string, eg. "00000" 
                                    width = max(length(num), length(zeros)) ;
# print("##### DEBUG ##### num=" num "; zeros=" zeros "; width=" width )                                

                                    return(substr(zeros num,length(zeros num)-width+1)) ;
}
                                    

BEGIN   {   OFS = "," ;

            print("Datetime,Server,CreatedBy,Description");

            monthname["January"]  = 1 ;
            monthname["February"] = 2 ;
            monthname["March"]    = 3 ;
            monthname["April"]    = 4 ;    
            monthname["May"]      = 5 ;
            monthname["June"]     = 6 ;
            monthname["July"]     = 7 ;
            monthname["August"]   = 8 ;
            monthname["September"]= 9 ;
            monthname["October"]  = 10 ;
            monthname["November"] = 11 ;
            monthname["December"] = 12 ;
}

/^Server.*halted/   {   server = $2 ;
                        servercount[server]++ ;



# Netware 4.11 date format is "weekday, Month dd, yyyy"
# Netware 5.1  date format is "weekday, dd Month yyyy"

# so I check for a comma on $6, indicating NW4.11 

			if (substr($6,length($6),1) == ",")
                        {
                            month  = $5 ;
                            day    = substr($6,1,length($6)-1) # remove comma
                        }
                        else
                        {
                            month = $6 ;
                            day   = $5 ;
                        }							


                        year   = $7 ;
                        time12 = $8 ;
                        ampm   = $9 ;

                        split(time12,time,":") ;
                        hour = time[1]%12 + (ampm=="am" ? 0 : 12)
                        datetime = year "-" leftzero(monthname[month],"00") "-" leftzero(day,"00") " " leftzero(hour,"00") ":" time[2] ":" time[3] ;

                        getline ;
                        description = $0 ;

                        total++ ;                    

}

/^Created by/       {   createdby = $3 ;
                        createdbycount[createdby]++ ;
}


/^\*/               {   if(server createdby datetime description)  # avoid blank lines
                            print(datetime, printcsv(server), printcsv(createdby), printcsv(description) );
}

END                 {   print(datetime, printcsv(server), printcsv(createdby), printcsv(description) );

                        print("=====") ;
                		print("Total," total) ;
                		print("");

	                    print("Created By") ;
                 		for(i in createdbycount)
                			print(i "," createdbycount[i])
                        print("") ;

                        print("Server");
                 		for(i in servercount)
                			print(i "," servercount[i])
}

# EOF: abend2csv.awk
