@echo off
title ABEND-ANALYZER %1
goto begin

Program :   abend-analyzer.bat
Purpose :   Retrieve all ABEND.LOG files from MDS servers, analyze cause and frequency, generate report
Author  :   Bob Jonkman  <bjonkman@sobac.com>

# Copyright 2008 Bob Jonkman and/or SOBAC Microcomputer Services

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

Date    :   20 July 2007

Parameters  :   %1 == nodelete  - Do not delete existing ABEND.LOG files (but copy any additional ABEND.LOGs from servers)
                %1 == nocollect - Do not copy ABEND.LOG files from server (use existing logs)
                %1 == noparse   - Do not parse ABEND.LOG files (use existing ABEND.CSV to analyze and generate report)
		%1 == noanalyze - Do not delete, collect, parse or analyze; generate HTML report only
		%1 == nodisplay - Delete, collect, parse, analyze and generate report, but do not display it.


:begin
if not "%1"=="" goto %1

:nodisplay

del abend*.log
:nodelete


echo gathering ABEND.LOG files...

rem for syntax of 'for' command see http://www.microsoft.com/resources/documentation/windows/xp/all/proddocs/en-us/batch.mspx?mfr=true
for /F "eol=# delims=\ tokens=1*" %%i in (c:\bin\servers.cfg) do echo %%i & copy \\%%i\SYS\SYSTEM\ABEND.LOG "ABEND %%i %date%.log"

:nocollect

rem Datetime,Server,CreatedBy,Description
gawk -f abend2csv.awk -f library.awk abend*.log > abend.csv
:noparse

gawk -f xtab.awk -f library.awk -v XFIELDNAME=Server    -v YFIELDNAME=CreatedBy abend.csv              > abend-xtab-createdby-by-server.csv
gawk -f xtab.awk -f library.awk -v XFIELDNAME=Server    -v YFIELDNAME=Datetime -v DATESLOT=1 abend.csv > abend-xtab-datetime-by-server.csv
gawk -f xtab.awk -f library.awk -v XFIELDNAME=CreatedBy -v YFIELDNAME=Datetime -v DATESLOT=1 abend.csv > abend-xtab-datetime-by-createdby.csv
:noanalyze

gawk -f csv2html.awk -f library.awk -v LINK=1 -v SORTABLE=1 -v TITLE="Netware Server Abend Log Analysis" abend-xtab*.csv abend.csv > abend-analyzer.html

rem Display the report
if not "%1"=="nodisplay" abend-analyzer.html

:end

rem EOF: abend-analyzer.bat
