# Program    : CODE2HTML.AWK
# Purpose    : Convert various program and code files to an HTML page with <code> constructs
# Date       : 13 October 2006
# Author     : Bob Jonkman <bjonkman@sobac.com>

# Copyright 2008 Bob Jonkman and/or SOBAC Microcomputer Services

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Usage      : gawk -f CODE2HTML.AWK -f LIBRARY.AWK [-v TITLE=title] [-v LINK=(0|1)] 1*(filename.csv)
#               http:\\hostname\code2html.awk?FILENAME=filename.ext[1*(+filename.ext)][&TITLE=title][&LINK=(0|1)]
# Note       : Use a + to separate filenames in URI

# Variables  :   TITLE = HTML <title> and <h1> elements for the page
#                LINK  = Creates link to FILENAME for each table
#                NOHTTP    = Suppress  a "Content-type: text/html" line for dynamic pages


function makemenu(topofpage)    {
    # Create header/footer menu
    # parameter==TRUE then include "Top of page" link
            print("   <div class=" QUOTE "menu" QUOTE ) ;
            if(!topofpage)  # if this is NOT at the top of page then ...
                print("        id=" QUOTE "toc" QUOTE ) ;
            print("    >") 
            print("    <p>In this page:</p>") ;
            print("    <ul>" )

            if (topofpage)
            {
                print("     <li>[<a href=" QUOTE "#top-of-page" QUOTE " class=" QUOTE "internal" QUOTE ">Top of this page</a>] </li>")
                print("     <li>[<a href=" QUOTE "#toc" QUOTE " class=" QUOTE "internal" QUOTE ">Table of Contents</a>] </li>")
            }

            for(i=1; i<ARGC; i++)
            {
                print("     <li>[<a class=" QUOTE "internal" QUOTE " href=" QUOTE "#" valnameid(ARGV[i]) QUOTE ">" txt2html(ARGV[i]) "</a>] </li>") 
            }
            print("   </ul>")
            print("  </div> <!-- end of menu  -->")
}




BEGIN    {  QUOTE = "\"" 

            if(!FIELD_SEPARATOR)
                FIELD_SEPARATOR = "," ;

            if(!FIELD_DELIMITER)
                FIELD_DELIMITER = "\"" ;

            if(!RECORD_SEPARATOR)
                RECORD_SEPARATOR = "\n" ;

            parsecgi(ENVIRON["QUERY_STRING"],qstring)

            if(ARGC == 1)   # no files on the command line
            {
                if(qstring["FILENAME"])
                {
                    ARGC = 1 + split(qstring["FILENAME"],ARGV," ")
                }
            }


            if(!NOHTTP)
                NOHTTP = !(ENVIRON["REQUEST_METHOD"]) ;
            
            if(!TITLE)
                TITLE = qstring["TITLE"]

            if(!TITLE)          # if there is still no title then...
                TITLE = "Code Files"

            if(!LINK)
                LINK = qstring["LINK"]


        printhtmlhead(TITLE)

 print(                   "<!-- ##### DEBUG ##### ARGC= " ARGC)           
     for(i in ARGV) print("     ##### DEBUG ##### ARGV[" i "]= " ARGV[i]) ;
 print(                   "     ##### DEBUG ##### -->")                  

        print(" <body><a id=" QUOTE "top-of-page" QUOTE " name=" QUOTE "top-of-page" QUOTE "></a>")
        print("  <h1>" makehtml(TITLE) "</h1>")

        if (ARGC == 1)
        {   print("  <div id=" QUOTE "content" QUOTE ">")
            print("   <p>No files specified, nothing to do!</p>")

            exit    # this will process END{}
        }

        if (ARGC > 2)       # If there is more than one file on the page
            makemenu(0) ;   #   create header menu without "Top of page" link

        print("  <div id=" QUOTE "content" QUOTE ">")

    }

(FNR == 1)    {     
# print("<!-- ##### DEBUG ##### FILENAME= " FILENAME " (FILENAME != oldfilename) FILENAME= " FILENAME " oldfilename= " oldfilename " -->")

        if(ARGIND > 1)        # check if we've processed multiple files
                {   print("   </code></pre>") 
                    print("   </div> <!-- end of id=" QUOTE valnameid(ARGV[ARGIND-1]) QUOTE " -->") ;
                    print("") 
                }

        print("   <div  id=" QUOTE valnameid(FILENAME) QUOTE ">") ;
        print("    <h2")
        if (ARGIND != 1)   #  Suppress page-break-before on the first file
            print("        style=" QUOTE "page-break-before: always ; " QUOTE )

        print("       >")

        if (ARGC > 2)   # Display "Prev, Top, Next" navigational aids
        {
            print("    <span class=" QUOTE "internal navaid" QUOTE ">")

            if (ARGIND != 1)       # suppress "Previous" for first file    
            {
                print("     <a href=" QUOTE "#" valnameid(ARGV[ARGIND-1]) QUOTE)
                print("        title=" QUOTE "Previous Table: " txt2html(ARGV[ARGIND-1]) QUOTE)
                print("     >&larr;</a>")
            } else
            {   print("     <span class=" QUOTE "disabled" QUOTE ">&larr;</span>")
            }

            print("     <a href=" QUOTE "#top-of-page" QUOTE)
            print("        title=" QUOTE "Go to the top of this page" QUOTE)
            print("     >&thinsp;&uarr;&thinsp;</a>")

            if (ARGIND < ARGC-1 )    # suppress "Next" for last file
            {
                print("     <a href=" QUOTE "#" valnameid(ARGV[ARGIND+1]) QUOTE)
                print("        title=" QUOTE "Next Table: " txt2html(ARGV[ARGIND+1]) QUOTE)
                print("     >&rarr;</a>")
            } else
            {   print("     <span class=" QUOTE "disabled" QUOTE ">&rarr;</span>")
            }
        print("    </span>")
        }
# print("<!-- ##### DEBUG #####  ARGIND=" ARGIND ", ARGC=" ARGC " -->")

        print("   " txt2html(FILENAME) "</h2>" )


        print("    <p>Generated on <abbr class=" QUOTE "datetime" QUOTE " title=" QUOTE strftime("%Y-%m-%dT%H:%M:%S") QUOTE ">" strftime("%a, %d %b %Y %H:%M:%S %z") "</abbr> from ") 

        if(LINK)
            print("     <a href=" QUOTE txt2uri(FILENAME) QUOTE ">" txt2html(FILENAME) "</a>") 
        else
            print("    " txt2html(FILENAME))

        print("    </p>")
        print("    <pre><code>") 

}




# Main : process for every line in the file
        {   print(txt2html($0))
}
                

END {   if(ARGIND)    
        {    print("    </code></pre>") 
             print("   </div> <!-- end of id=" QUOTE valnameid(FILENAME) QUOTE " -->") ;
        }
        print("   <p>" ARGIND " files processed.</p>") 
        print("  </div> <!-- end of content -->") 

        if (ARGC > 2)       # If there is more than one file on the page
        {   print("  <div id=" QUOTE "footer" QUOTE ">")
            makemenu(1) ;   #   Create footer menu with "Top of page" link
            print("  </div> <!-- end of footer -->")
        }

        print(" </body>")     
        print("</html>") 
    }

# EOF: CODE2HTML.AWK
