# Shebang goes here

# Program   :   ndirvol2csv.awk
# Purpose   :   Convert output from `ndir server\volume: /vol` to a .CSV file
# Author    :   Bob Jonkman   <bjonkman@sobac.com>

# Copyright 2008 Bob Jonkman and/or SOBAC Microcomputer Services

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Date      :   26 July 2007
# Updated   :   20 August 2007 - Fixed print last record when no "namespacesloaded"


function delcomma(number)   {
            gsub(/,/,"",number) ;
            return(number) ;
}

BEGIN   {   OFS = "," ;
            ORS = "" ;

            print("Volume,")
            print("Total volume space,")
            print("Space used by entries,")
            print("Deleted space not yet purgeable,")
            print("Space remaining on volume,")
            print("Percent space remaining on volume,")
            print("Directory entries,")
            print("Maximum directory entries,")
            print("Available directory entries,")
            print("Percent available directory entries,")
            print("Space used if files were not compressed,")
            print("Space used by compressed files,")
            print("Space saved by compressing files,")
            print("Percent space saved by compressing files,")
            print("Uncompressed space used,")
            print("Name spaces loaded") ;
            print("\n") ;

}


(oldargind != ARGIND) && (ARGIND > 1)       {   # Print the record when the next file is read
                                                print(printcsv(volinfo["volume"]) ",") ;
                                                print(delcomma(volinfo["totalvolumespace"]) ",") ;
                                                print(delcomma(volinfo["spaceusedby"]) ",") ;
                                                print(delcomma(volinfo["deletedspace"]) ",") ;
                                                print(delcomma(volinfo["spaceremaining"]) ",") ;
                                                print(delcomma(volinfo["percentspaceremaining"]) ",") ;
                                                print(delcomma(volinfo["entries"]) ",") ;
                                                print(delcomma(volinfo["maximumdirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["availabledirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["percentavailabledirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["spaceusediffileswerenotcompressed"]) ",") ;
                                                print(delcomma(volinfo["spaceusedbycompressedfiles"]) ",") ;
                                                print(delcomma(volinfo["spacesavedbycompressingfiles"]) ",") ;
                                                print(delcomma(volinfo["percentspacesavedbycompressingfiles"]) ",") ;
                                                print(delcomma(volinfo["uncompressedspaceused"]) ",") ;
                                                print(printcsv(volinfo["namespacesloaded"])) ;
                                                print("\n")

                                                delete volinfo ;                                                
                                                oldargind = ARGIND ;
}


/Statistics for fixed volume/               {    volinfo["volume"] =  $NF ;
}

/Space used by .* entries/                  {    volinfo["entries"] =  $4 ;
                                                 volinfo["spaceusedby"] =  $(NF-1) ;
                                    
}

/Total volume space/                        {    volinfo["totalvolumespace"] =  $(NF-1) ;
}

/Deleted space not yet purgeable/           {    volinfo["deletedspace"] =  $(NF-1) ;
}

/Space remaining on volume/                 {    volinfo["spaceremaining"] =  $(NF-1) ;
                                                 volinfo["percentspaceremaining"] = $NF ;
}

/Maximum directory entries/                 {    volinfo["maximumdirectoryentries"] =  $NF ;
}

/Available directory entries/               {    volinfo["availabledirectoryentries"] =  $(NF-1) ;
                                                 volinfo["percentavailabledirectoryentries"] =  $NF ;
}

/Space used if files were not compressed/   {    volinfo["spaceusediffileswerenotcompressed"] =  $NF ;
}

/Space used by compressed files/            {    volinfo["spaceusedbycompressedfiles"] =  $NF ;
}

/Space saved by compressing files/          {    volinfo["spacesavedbycompressingfiles"] =  $(NF-1) ;
                                                 volinfo["percentspacesavedbycompressingfiles"] =  $NF ;
}

/Uncompressed space used/                   {    volinfo["uncompressedspaceused"] =  $NF ;
}

/Name spaces loaded/                        {   volinfo["namespacesloaded"] = $4
                                                for (i=5; i<=NF; i++)
                                                    volinfo["namespacesloaded"] =  volinfo["namespacesloaded"] " " $i ;
}

END                                         {   # Print the final record

                                                print(printcsv(volinfo["volume"]) ",") ;
                                                print(delcomma(volinfo["totalvolumespace"]) ",") ;
                                                print(delcomma(volinfo["spaceusedby"]) ",") ;
                                                print(delcomma(volinfo["deletedspace"]) ",") ;
                                                print(delcomma(volinfo["spaceremaining"]) ",") ;
                                                print(delcomma(volinfo["percentspaceremaining"]) ",") ;
                                                print(delcomma(volinfo["entries"]) ",") ;
                                                print(delcomma(volinfo["maximumdirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["availabledirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["percentavailabledirectoryentries"]) ",") ;
                                                print(delcomma(volinfo["spaceusediffileswerenotcompressed"]) ",") ;
                                                print(delcomma(volinfo["spaceusedbycompressedfiles"]) ",") ;
                                                print(delcomma(volinfo["spacesavedbycompressingfiles"]) ",") ;
                                                print(delcomma(volinfo["percentspacesavedbycompressingfiles"]) ",") ;
                                                print(delcomma(volinfo["uncompressedspaceused"]) ",") ;
                                                print(printcsv(volinfo["namespacesloaded"])) ;
                                                print("\n")
}

# EOF: ndirvol2csv.awk
