@echo off
title DISKFREE %1
goto begin

Program :   diskfree.bat
Purpose :   Create Netware server available diskspace report
Author  :   Bob Jonkman   <bjonkman@sobac.com>

# Copyright 2008 Bob Jonkman and/or SOBAC Microcomputer Services

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

Date    :   25 July 2007
Updated :   20 August 2007 - Added ndirvolume-diskfree.html report; include both trend tables on diskfree.html

Usage   :   diskfree [ parseonly | generateonly | trendonly | nodisplay ]

NOte	:   See http://www.microsoft.com/resources/documentation/windows/xp/all/proddocs/en-us/batch.mspx?mfr=true
            for syntax of 'for' command

:begin
rem DATE variable is "ddd yyyy-mm-dd" under Win2K, so needs quote delimiters
set filename="diskfree-%date%.csv"

if "%1"=="parseonly" goto parseonly
if "%1"=="generateonly" goto generateonly
if "%1"=="trendonly" goto trendonly

echo Deleting ndir*.tmp
if exist ndir*.txt del ndir*.txt

echo Gathering Netware Volume information...
rem Note: the `dir vol$err.log` is included to ensure there is a connection to the server before `ndir /vol`
for /F "eol=# delims=\ tokens=1*" %%i in (c:\bin\volumes.cfg) do echo %%i\%%j & dir \\%%i\%%j\vol$log.err > nul & ndir %%i\%%j: /vol > ndir-%%i-%%j.txt

:parseonly
echo Parsing data...
gawk -f ndirvol2csv.awk -f library.awk ndir*.txt > %filename%


:trendonly
echo Creating trend data
gawk -f trend.awk -f library.awk -v SOURCEHEADER=Volume -v SOURCEFIELD="Percent space remaining on volume" diskfree*.csv > trend-percent-available-diskfree.csv
gawk -f trend.awk -f library.awk -v SOURCEHEADER=Volume -v SOURCEFIELD="Space remaining on volume" diskfree*.csv > trend-available-diskfree.csv
gawk -f trend.awk -f library.awk -v SOURCEHEADER=Volume -v SOURCEFIELD="Space used by entries" diskfree*.csv > trend-used-diskfree.csv

:generateonly
echo Generating report...
gawk -f csv2html.awk  -f library.awk -v LINK=1 -v SORTABLE=1 -v TITLE="Netware Server Available Disk Space (kiBytes)" trend*.csv  %filename% > diskfree.html
gawk -f code2html.awk -f library.awk -v LINK=1 -v TITLE="Netware Servers Volume Data" ndir*.txt > ndirvol-diskfree.html


rem Display the pretty report.
if not "%1"=="nodisplay" diskfree.html

set filename= 

rem EOF:  diskfree.bat
